// HtmlToRtf.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"

#include "com_sautinsoft_HtmlToRtf.h"
#include "jni.h"


#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <iostream>
#include <fstream>

using namespace std;

struct ConvertSettings
{		
	int PreserveTables;				//1 - preserve tables, 0 - transfer to text
	int PreserveImages;				//1 - preserve images,  0 - skip
	int PreserveHyperlinks;			//1 - preserve hyperlinks, 0 - skip
	int PreserveFontFace;			//1 - preserve font faces as in HTML, 0 - all font faces will be as in 'FontFace'
	int PreserveFontSize;			//1 - preserve font sizes as in HTML, 0 - all font sizes will be as in 'FontSize'
	int PreserveFontColor;			//1 - preserve font colors as in HTML, 0 - black font color
	int PreserveBackgroundColor;	//1 - preserve bacground colors as in HTML, 0 - skip
	int PreserveAlignment;			//1 - preserve alignment as in HTML, 0 - all text will have align as in 'PageAlignment'
	int PreserveTableWidth;			//1 - preserve width of columns
	int PreserveNestedTables;		//1 - preserve nested tables, 0 - translate nested tables to plain tables
	int PageMarginLeft;				//page margin left, mm. For example 10
	int PageMarginRight;			//page margin right, mm. For example 10
	int PageMarginTop;				//page margin top, mm. For example 10
	int PageMarginBottom;			//page margin bottom, mm. For example 10
	int BorderVisibility;			//table borders: 1 - visible borders, 0 - hidden borders, 2 - as in HTML
	int PageOrientation;			//page orientation: 0 - Portrait, 1 - Landscape
	int PageSize;					//page size: 0 - A4, 1 - A3, 2 - A5, 3 - B5, 4 - Letter, 5 - Legal, 6 - Executive, 7 - Monarh
	int FontFace;					//default font face: Arial - 0, Times New Roman - 1, Verdana - 2, Helvetica - 3, Courier - 4, Courier New - 5, Times - 6, Georgia - 7, MS Sans Serif - 8,
									//Futura - 9, Arial Narrow - 10, Garamond - 11, Impact - 12, Lucida Console - 13, Tahoma - 14, Inform - 15, Symbol - 16, WingDings - 17, Traditional Arabic - 18
	int FontSize;					//default font size, any value from 6 to 72
	int PageAlignment;				//page alignment: 0 - left, 1 - center, 2 - right, 3 - justify
	int RtfLanguage;				//RTF language: English - 1033, Albanian - 1052, Belgian - 2067, Bulgarian - 1026, Hungarian - 1038, Danish - 1030, Spanish - 3082, Latvian - 1062, Lithuanian - 1063,
									//German - 1031, Netherlands - 1043, Norwegian - 2068, Portuguese - 2070, Romanian - 1048, Russian - 1049, Ukrainian - 1058, Finnish - 1035, French - 1036,
									//Czech - 1029, Swedish - 1053, Arabic - 1053, Turkish - 1055, Japanese - 932, SimplifiedChinese - 936, TraditionalChinese - 950, Korean - 949, Thai = 874
	int Encoding;					//AutoSelect - 0, ISO-8859-1 - 1, ISO-8859-5 - 2, KOI8-R - 3, Windows-1251 - 4, UTF-8 - 5, Windows-1254 - 6, Windows-1256 - 7,
									//Windows-1250 - 8, Windows-1252 - 9, Windows-1253 - 10, Windows-1255 - 11, Windows-1257 - 12, Windows-1258 - 13
	int OutputTextFormat;			//Output Format: Rtf - 0, Text - 1, Doc - 2 (only file with .doc extension)  
	int PreservePageBreaks;			//1 - preserve page-breaks
	int ImageCompatible;			//type of produced images: Word - 0, WordPad - 1
	int PageNumbers;				//page numbers: 0 - disable, 1 - numbers from first page, 2 - from second page
	char PageHeader[150];			//page header, any string
	char PageFooter[150];			//page footer, any string
	char HtmlPath[650];				//html path for method 'htmltortf_string', will be used for find images (now is not used)
	int PageNumbersAlignV;			//page numbers vertical align: Top - 4, Bottom - 5
	int PageNumbersAlignH;			//page numbers horizontal align: 0 - left, 1 - center, 2 - right, 3 - justify
	int PreserveHR;					//1 - preseve <hr>, 0 - skip
	int RtfParts;
	int CreateTraceFile;
	char TraceFilePath[650];

};

typedef enum eBorderVisibility
{
	Hidden=0,
	Visible=1,		
	SameAsOriginalHtml=2	
} eBorderVisibility;

typedef enum eFontFace
{
	f_Arial=0,
	f_Times_New_Roman=1,
	f_Verdana=2,
	f_Helvetica=3,
	f_Courier=4,
	f_Courier_New=5,
	f_Times=6,
	f_Georgia=7,
	f_MS_Sans_Serif=8,
	f_Futura=9,
	f_Arial_Narrow=10,
	f_Garamond=11,
	f_Impact=12,
	f_Lucida_Console=13,
	f_Tahoma=14,
	f_Inform=15,
	f_Symbol=16,
	f_WingDings=17,
	f_Traditional_Arabic=18
				
} eFontFace;

typedef enum eEncoding
{
	AutoSelect=0,
	ISO_8859_1=1,
	ISO_8859_5=2,
	KOI8_R=3,
	Windows_1251=4,
	UTF_8=5,
	Windows_1254=6,
	Windows_1256=7,
	Windows_1250=8,
	Windows_1252=9,
	Windows_1253=10,
	Windows_1255=11,
	Windows_1257=12,
	Windows_1258=13
} eEncoding;

typedef enum ePageAlignment
{
	AlignLeft=0,
	AlignCenter=1,
	AlignRight=2,
	AlignJustify=3,
	AlignTop=4,
	AlignBottom=5
} ePageAlignment;

typedef enum eOutputTextFormat
{
	Rtf=0,
	Text=1,		
} eOutputTextFormat;

typedef enum eLanguage
{
	l_Albanian = 1052,
    l_English = 1033,
    l_Belgian = 2067,
    l_Bulgarian = 1026,
    l_Hungarian = 1038,
    l_Danish = 1030,
    l_Spanish = 3082,
    l_Latvian = 1062,
    l_Lithuanian = 1063,
    l_German = 1031,
    l_Netherlands = 1043,
    l_Norwegian = 2068,
    l_Portuguese = 2070,
    l_Romanian = 1048,
    l_Russian = 1049,
    l_Ukrainian = 1058,
    l_Finnish = 1035,
    l_French = 1036,
    l_Czech = 1029,
    l_Swedish = 1053,
	l_Arabic = 1053,
	l_Turkish = 1055,
	l_Japanese = 932,
	l_SimplifiedChinese = 936,
	l_TraditionalChinese = 950,
	l_Korean = 949,
	l_Thai = 874

} eLanguage;

//Page Orientation
typedef enum ePageOrientation
{
	Portrait=0,
	Landscape=1,
} ePageOrientation;

//Page Size
typedef enum ePageSize
{
	A4=0,
	A3=1,
	A5=2,
	B5=3,
	Letter=4,
	Legal=5,
	Executive=6,
	Monarh=7
} ePageSize;

typedef enum eImageCompatible
{
	image_Word=0,
	image_WordPad=1,
} eImageCompatible;

typedef enum ePageNumbers
{
	PageNumDisable=0,
	PageNumFirst=1,
	PageNumSecond=2
} ePageNumbers;


typedef char * (* cfuncstring)(char * html, char * rtf, struct ConvertSettings);
cfuncstring htmltortf_string; //converts html to rtf

typedef int (* cfuncfile)(char *htmlfile, char *outfolder, struct ConvertSettings);
cfuncfile htmltortf_file; //converts html to rtf

typedef int (* cfuncflush)(void);
cfuncflush flushlist; //releases memory



BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    return TRUE;
}


/*
 * Class:     com_sautinsoft_HtmlToRtf
 * Method:    htmltortf_file
 * Signature: (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_sautinsoft_HtmlToRtf_htmltortf_1file
  (JNIEnv *env, jobject obj, jstring htmlFile, jstring rtfFolder)
{
	//load library
	HINSTANCE hMod = LoadLibrary("htmltortf_sautinsoft.dll");
	if (hMod == NULL) {
		return env->NewStringUTF("ERROR: Unable to load library");
	}

	htmltortf_file = (cfuncfile)GetProcAddress(hMod, "htmltortf_file");
	if (htmltortf_file == NULL) {
		FreeLibrary((HMODULE)hMod);
	    return env->NewStringUTF("ERROR: Can't load function htmltortf_file");
	}


	//SET PARAMETERS
	struct ConvertSettings cs;
	cs.BorderVisibility = SameAsOriginalHtml;
	cs.Encoding = AutoSelect;
	cs.FontFace = f_Arial;
	cs.FontSize = 10;
	strcpy(cs.HtmlPath, "");
	cs.ImageCompatible = 0;
	cs.OutputTextFormat = Rtf;
	cs.PageAlignment = AlignLeft;
	strcpy(cs.PageHeader, "");
	strcpy(cs.PageFooter, "");
	cs.PageMarginBottom = 10;
	cs.PageMarginLeft = 10;
	cs.PageMarginRight = 10;
	cs.PageMarginTop = 10;
	cs.PageNumbers = PageNumDisable;
	cs.PageNumbersAlignH = 2;
	cs.PageNumbersAlignV = 5;
	cs.PageOrientation = Portrait;
	cs.PageSize = Letter;
	cs.PreserveAlignment = true;
	cs.PreserveBackgroundColor = true;
	cs.PreserveFontColor = true;
	cs.PreserveFontFace = true;
	cs.PreserveFontSize = true;
	cs.PreserveHR = true;
	cs.PreserveHyperlinks = true;
	cs.PreserveImages = true;
	cs.PreserveNestedTables = true;
	cs.PreservePageBreaks = false;
	cs.PreserveTables = true;
	cs.PreserveTableWidth = true;
	cs.RtfLanguage = l_English;
	cs.RtfParts = 0;
	strcpy(cs.TraceFilePath,"C:\\report.txt");
	cs.CreateTraceFile = false;
	

	//CONVERT
	char *strHtmlFile = (char *)env->GetStringUTFChars(htmlFile, 0);
	char *strRtfFolder = (char *)env->GetStringUTFChars(rtfFolder, 0);

	int retValue = htmltortf_file(strHtmlFile, strRtfFolder, cs);

    env->ReleaseStringUTFChars(htmlFile, strHtmlFile);
    env->ReleaseStringUTFChars(rtfFolder, strRtfFolder);

	if (retValue = 1)
		return env->NewStringUTF("");
	else
		return env->NewStringUTF("ERROR: Could not convert Html File.");
}



/*
 * Class:     com_sautinsoft_HtmlToRtf
 * Method:    htmltortf_string
 * Signature: (Ljava/lang/String;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_sautinsoft_HtmlToRtf_htmltortf_1string
  (JNIEnv *env, jobject obj, jstring sHtml)
{
	char * strHtml = NULL;
	char * strRtf = NULL;
	long size = 0;

	size = env->GetStringLength(sHtml);
	if ((strHtml = (char *) malloc(size * sizeof(char) + 1000)) == NULL) {
		return env->NewStringUTF("ERROR: Out of Memory");
	}
	const char *str = env->GetStringUTFChars(sHtml, 0);
	strcpy(strHtml, str);
    env->ReleaseStringUTFChars(sHtml, str);
	
	//load library
	HINSTANCE hMod = LoadLibrary("htmltortf_sautinsoft.dll");
	if (hMod == NULL) {
		free(strHtml);	  
		return env->NewStringUTF("ERROR: Unable to load library");
	}

	htmltortf_string = (cfuncstring)GetProcAddress(hMod, "htmltortf_string");
	if (htmltortf_string == NULL) {
		FreeLibrary((HMODULE)hMod);
	    free(strHtml);	  
	    return env->NewStringUTF("ERROR: Can't load function htmltortf_string");
	}

	flushlist = (cfuncflush)GetProcAddress(hMod, "flushlist");
	if (flushlist == NULL) {
		FreeLibrary((HMODULE)hMod);
	    free(strHtml);	  
	    return env->NewStringUTF("ERROR: Can't load function flushlist");
	}

	//SET PARAMETERS
	struct ConvertSettings cs;
	cs.BorderVisibility = SameAsOriginalHtml;
	cs.Encoding = AutoSelect;
	cs.FontFace = f_Arial;
	cs.FontSize = 10;
	strcpy(cs.HtmlPath, "");
	cs.ImageCompatible = 0;
	cs.OutputTextFormat = Rtf;
	cs.PageAlignment = AlignLeft;
	strcpy(cs.PageHeader, "");
	strcpy(cs.PageFooter, "");
	cs.PageMarginBottom = 10;
	cs.PageMarginLeft = 10;
	cs.PageMarginRight = 10;
	cs.PageMarginTop = 10;
	cs.PageNumbers = PageNumDisable;
	cs.PageNumbersAlignH = 2;
	cs.PageNumbersAlignV = 5;
	cs.PageOrientation = Portrait;
	cs.PageSize = Letter;
	cs.PreserveAlignment = true;
	cs.PreserveBackgroundColor = true;
	cs.PreserveFontColor = true;
	cs.PreserveFontFace = true;
	cs.PreserveFontSize = true;
	cs.PreserveHR = true;
	cs.PreserveHyperlinks = true;
	cs.PreserveImages = true;
	cs.PreserveNestedTables = true;
	cs.PreservePageBreaks = false;
	cs.PreserveTables = true;
	cs.PreserveTableWidth = true;
	cs.RtfLanguage = l_English;
	cs.RtfParts = 0;
	strcpy(cs.TraceFilePath,"C:\\report.txt");
	cs.CreateTraceFile = false;
	
	//CONVERT
	strRtf = htmltortf_string(strHtml, strRtf, cs);

	string result = "";
	result.append(strRtf);

	//release memory
	flushlist();
	free(strHtml);

	return env->NewStringUTF(result.c_str());
}
